clear;clc;
close all;

cepath='D:\MATLAB-2018\CompEcon\'; path([cepath 'cetools;' cepath 'cedemos'],path);

%% Parameters
mu_us = 0.2; 
mu_cn = 0.2;

mu_rw = 1-mu_us-mu_cn;

beta = 0.98;

bbar_usd =  1.471;

bbar_cny_grid = (0.971:0.02:1.471)';
n_bbar_cny = size(bbar_cny_grid,1);

bbar_cny = 1.2;

r = 0.005; 
%phi= (pi-r)/(bbar_us+1); 
phi = 0.01;
pi = 1;

phi_sunspot1 = (pi-r)/(bbar_usd+0.5*mu_rw+0.5);
phi_sunspot2 = zeros(n_bbar_cny,1);

for i=1:n_bbar_cny
    bbar_cny1 = bbar_cny_grid(i);
    phi_sunspot2_grid = (pi-r)/(bbar_cny1+0.5*mu_rw+0.5);
    
    phi_sunspot2(i) = phi_sunspot2_grid;
end

% phi < min(phi_sunspot1,phi_sunspot2);

%% Using fsolve to solve model

%{
S_rw = zeros(n_tau_grid,1);

for j = 1:n_tau_grid
    tau = tau_grid(j);
    srw = fsolve(@(srw) dollarusage_tau(srw, mu_us, mu_cn, mu_rw, beta, tau, pi, r, phi, bbar_usd, bbar_cny), 0.1);
    
    S_rw(i) = srw;
end

%}

%% Guess the value of srw

tic

tolerance =1e-3;

tau_grid = (0:0.01:1)';
%tau_grid = 0.0001;
n_tau_grid = size(tau_grid,1);

srw_guess = (0.01:0.01:0.99)';
n_srw_guess = size(srw_guess,1);

options = optimset('Display','Final','TolX',1e-3,'TolFun',1e-3);

b_cny_rw1 = zeros(n_tau_grid,n_srw_guess);
b_cny_rw2 = zeros(n_tau_grid,n_srw_guess);
b_cny_rw_aux = zeros(n_tau_grid,n_srw_guess);
Dist = zeros(n_tau_grid,n_srw_guess);

    for i_tau = 1:n_tau_grid
        
        for i_srw = 1:n_srw_guess
            
            tau = tau_grid(i_tau);
            srw = srw_guess(i_srw);
  
            b_cny_rw1 = fsolve(@(b_cny_rw) Chen_b_cny_j(b_cny_rw, bbar_cny, srw, mu_cn, mu_rw, beta, tau, r), 0.05,options);
            b_cny_rw1(i_tau,i_srw) = b_cny_rw1;

            b_cny_rw2 = fsolve(@(b_cny_rw) Chen_b_cny_j_Poly(srw, mu_cn, mu_rw, beta, tau, r, bbar_cny, b_cny_rw), 0.05,options);
            b_cny_rw2(i_tau,i_srw) = b_cny_rw2;
            
            Dis = Chen_xrw_Dis(srw, mu_us, mu_rw, pi, r, phi, bbar_usd, b_cny_rw1);
            
            %{
            Dist(i_tau,i_srw) = Dis;

            if abs(Dis)<tolerance
                
                position = i_srw;
                
                srw_solved = srw_guess(position);
                
            end
            %}

        end
        
    end

toc 

%{    
[data,~,~] = xlsread('E:\Project2_theories\Statistical Evidence\Statistical Evidence.xlsx', 'Sheet1','A1:B21');
Dollar_usage = data(:,1);
Renminbi_usage = data(:,2);
figure;
subplot(2,1,1)
plot(tau_grid,Dollar_usage,'r-','LineStyle','-.','LineWidth',1.5)                
subplot(2,1,2)
plot(tau_grid,Renminbi_usage,'b','LineStyle','-','LineWidth',1.5)              
%}            

        
  









